/**
 * Shows the configuration and provides an interface to create/drop the configuration-table, and add/update properties.
 * @author nl.ivojonker
 */
define([
        "dojo/_base/declare",
        "dijit/_TemplatedMixin",
        "dijit/_WidgetsInTemplateMixin",
        "dojo/query",
        "ecm/widget/admin/PluginConfigurationPane",
        "dojo/text!./templates/ConfigurationPane.html",
        "./ConfigurationRow",
        "idx/layout/TitlePane",
        "dojo/_base/lang",
        "dojo/aspect",
        "ecm/model/Request"
        ],
        function(declare, _TemplatedMixin, _WidgetsInTemplateMixin, query, PluginConfigurationPane, template, ConfigurationRow, TitlePane, lang,aspect, Request) {

	function alert(message){
		new ecm.widget.dialog.MessageDialog({text:message}).show();
	}
	
	return declare("CentralConfigurationPluginDojo.ConfigurationPane", [ PluginConfigurationPane, _TemplatedMixin, _WidgetsInTemplateMixin], {

		templateString: template,
		widgetsInTemplate: true,
		
		_domStatusJNDI : "domnode from template",
		_domStatusTABLENAME : "domnode from template",
		_domStatusSTATUS : "domnode from template",
		
		_addNewPropertyInput: "domnode from template",
		_propertyContainer : "domnode from template",

		_configuration: { config: [] /*from service*/},
		
		/*
		 * Add's a new empty configuration entry to _configuration.config and then re-renders the config page.
		 */
		_addNewProperty:function(){
			var newKey = this._addNewPropertyInput.getValue();
			//key should not be empty
			if (!newKey || newKey.trim().length==0){
				alert("A configuration entry needs a key as an identifier.<br><br>Please fill in a key.");
				this._addNewPropertyInput.domNode.style.border="2px solid red";
				return;
			}
			
			if (newKey.split(".").length<2){
				alert("A key should contain a namespace.<br><br>Invalid key: ceURL<br>Valid key: ce.url");
				this._addNewPropertyInput.domNode.style.border="2px solid red";
				return;
			}
			
			newKey=newKey.trim();
			//key should not already exist
			for (var i=0;i<this._configuration.config.length;i++){
				if (this._configuration.config[i].key==newKey){
					alert("A configuration entry already exists with this key.");
					this._addNewPropertyInput.domNode.style.border="2px solid red";
					return;
				}
			}
			
			this._addNewPropertyInput.domNode.style.border="";
			
			var newProperty = {value:'enter value here',key:newKey,evaluate:false,expose:false,description:"Describe the purpose of this configuration key here.."};
			this._addNewPropertyInput.setValue('');
			this._configuration.config.push(newProperty);

			this._renderConfiguration();
		},
		
		_deleteProperty: function(){
			var keyToDelete = this._addNewPropertyInput.getValue();
			var config = this._configuration.config;
			
			for (var i=0;i<config.length;i++){
				if (config[i].key==keyToDelete){
					alert("Deleted the following entry:<br>"+JSON.stringify(config.splice(i,1)[0]));
					this._renderConfiguration();
					return;
				}
			}
			alert("Nothing was deleted. hint: keys are case sensitive.");
		},
		
		_promptJSON : function(){
			var $this = this;
			require(["ecm/widget/dialog/ConfirmationDialog","dijit/form/SimpleTextarea"], function(ConfirmationDialog,SimpleTextarea){
				var textArea = new SimpleTextarea({
					value: JSON.stringify($this._configuration.config),
					style: "width:100%;",
					rows: 10
				});
				
				var dialog= new ConfirmationDialog(
						{title:"This JSON represents the complete configuration. ", 
							text:'',
							buttonLabel: "Save", 
							cancelButtonDefault:false,
							style:"width:80%;height:280px;",
							onExecute: function(){
								$this._configuration.config=JSON.parse(textArea.value); 
								$this._renderConfiguration();
								this.destroy();
							}}
				);
				textArea.placeAt(dialog.description);
				dialog.show();
				
			});

		},

		/*
		 * Create's a rendering of the config. entries using /ConfigurationRow and idx.layout.TitlePane widgets.
		 */
		_renderConfiguration: function(){
			this._propertyContainer.innerHTML="";
			this._domStatusJNDI.innerHTML=this._configuration.jndi;
			this._domStatusTABLENAME.innerHTML=this._configuration.tablename;
			this._domStatusSTATUS.innerHTML=this._configuration.status;
			
			/* This subroutine ensures the creation of the property group containers.*/
			var containers={};
			function ensureGroupContainer(canonicalKey,currentParent){
				var keyParts = canonicalKey.split(".");
				
				var currentId=""; 
				for (var i=0;i<keyParts.length-1;i++){
					currentId+=(currentId.length>0?".":"")+keyParts[i];
					
					if (containers[currentId]){
						currentParent=containers[currentId];
					}else{
						var contentDiv = document.createElement("div");
						new TitlePane({title: currentId, content:contentDiv}).placeAt(currentParent);
						containers[currentId]=currentParent=contentDiv;
					}
					
					if (i==keyParts.length-2)
						return containers[currentId];
				}
				throw "Unexpected outcome";
			}
			
			//alphabetically sort the properties
			var configuration=this._configuration.config.sort(function (a,b){
				if (a.key>b.key) return 1; if (a.key<b.key) return -1; else return 0;
			});
			
			//the Groups/TitlePanes are created in a seperate loop to ensure groups are displayed first
			for (var i=0; i<configuration.length;i++)
				ensureGroupContainer(configuration[i].key,this._propertyContainer);

			for (var i=0; i<configuration.length;i++){
				var config = configuration[i];
				var targetContainer = ensureGroupContainer(config.key,this._propertyContainer);
				
				var newConfigWidget=new ConfigurationRow({
					config:config,
					onChange:lang.hitch(this,function(){
						this.onSaveNeeded(true);
					})
				});
				
				newConfigWidget.placeAt(targetContainer);				
			}	

		},
		/*
		 * The load function is triggered by ICN and requests status & configuration.
		 */
		load: function(callback) {
			var $this=this;
			Request.invokePluginService("CentralConfigurationPlugin","ConfigurationService",{
				requestParams: {instruction:"status"},
				requestCompleteCallback: function(statusObject){
					$this.handleServiceResponse(statusObject);
				},
				requestFailedCallback: function(){
					alert("An error occured while retrieving data from the ConfigurationService, please see the console.");
					console.log("Error invoking ConfigurationService. Response arguments:");
					console.log(arguments);
				}
			});
		},
		
		handleServiceResponse: function(status){
			this._configuration=status;
			this._renderConfiguration();
		},
		
		/* As we're not using the plugin-configuration string, we need our own save.
		 * This function will be aspect'd.after on adminpage.onSaveWithCallback
		 */
		save: function(){
			var $this=this;
			Request.invokePluginService("CentralConfigurationPlugin","ConfigurationService",{
				requestParams: {instruction:"persist", persist: JSON.stringify(this._configuration.config)},
				requestCompleteCallback: function(statusObject){
					$this.handleServiceResponse(statusObject);
				},
				requestFailedCallback: function(){
					$this._domStatusSTATUS.innerHTML="Failed saving the CentralConfiguration. Please see the console log for more information.";
					console.error(arguments);
				
				}
			});
		},
		/*
		 * Drops the configuration table.
		 */
		_dropTable: function(){
			var $this=this;
			Request.invokePluginService("CentralConfigurationPlugin","ConfigurationService",{
				requestParams: {instruction:"droptable"},
				requestCompleteCallback: function(response){
					alert("The server sent the following response: <br><br>"+response.response);
				},
				requestFailedCallback: function(){
					alert("Failed dropping the table.<br><br>Please see the console for more information.");
					console.error(arguments);
				}
			});
		},
		/*
		 * Creates the configuration table.
		 */
		_createTable: function(){
			var $this=this;
			Request.invokePluginService("CentralConfigurationPlugin","ConfigurationService",{
				requestParams: {instruction:"createtable"},
				requestCompleteCallback: function(response){
					alert("The server sent the following response: <br><br>"+response.response+"<br><br>If table creation failed, note that the table can be created manually as well.");
					$this.load();
				},
				requestFailedCallback: function(){
					alert("Failed creating the table.<br><br>Please see the console for more information.");
					console.error(arguments);
				}
			});
		},
		
		/*
		 * Attaches the custom Save to the plugin-page's save
		 */
		startup : function(){
			this.inherited(arguments);
			try{	
				//search for the containing admin plugin page. 
				var curr=this;
				while (!curr._configClass && curr._configClass != this.declaredClass){
					curr=curr.getParent();
				}

				aspect.after(curr,"onSaveWithCallback",lang.hitch(this,this.save));
			}catch(any){
				alert("The configuration plugin could not connect to the Save button.<br><br>Possible due to an unsupported plugin? Please contact http://www.ivojonker.nl/ for a fix.");
			}
		},

		validate: function() {
			return true;
		}
		



	});
});
